/*
 * Tiny4kOLED - Drivers for SSD1306 controlled dot matrix OLED/PLED 128x32 displays
 *
 * Based on ssd1306xled, re-written and extended by Stephen Denne
 * from 2017-04-25 at https://github.com/datacute/Tiny4kOLED
 *
 */

#ifndef SOLOMON_SYSTECH_H
#define SOLOMON_SYSTECH_H

// The SSD1306 is designed by SOLOMON SYSTECH.
// So to demonstrate drawing bitmaps, I chose their logo.

// The oled.bitmap method expects the array it is given, to be in flash memory
// The PROGMEM in the next line is important, it puts the array in flash memory
const uint8_t solomon_systech_logo_bitmap[] PROGMEM = {
// The image was converted to a 64 x 32 pixel image

// Each set of eight rows get set as a sequence of bytes
// in the first eight rows, the first pixel is set on the 17th column
// so the data starts with 16 zeroes.
// All rows start with 6 zeroes, and end with 21 zeroes,
// so to save space that data is not stored here,
// and the image size is 37 x 32 pixels

// The 8 bit encoding of the data for 8 pixels has least significant bit at the top
// and the most significant bit at the bottom

// ................................................................ 0    1 Page 1
// ................................................................ 1    2
// ................................................................ 2    4
// ...........................########............................. 3    8
// .......................###############.......................... 4   16
// ....................####################........................ 5   32
// .................########################....................... 6   64
// ................####################............................ 7  128
// ..............#.....##########.................................. 0    1 Page 2
// ..................########...................................... 1    2
// ................#######......................................... 2    4
// ...............#####.................######..................... 3    8
// .............#####............#############..................... 4   16
// ...........####..........##################..................... 5   32
// ..........###........#####################...................... 6   64
// .........##......#########################...................... 7  128
// .......##....############################....................... 0    1 Page 3
// ......#...###############################....................... 1    2
// .......#####...............#############........................ 2    4
// ..........................#############......................... 3    8
// .........................#############.......................... 4   16
// ........................#############........................... 5   32
// .......................#############............................ 6   64
// .....................##############............................. 7  128
// ...................##############............................... 0    1 Page 4
// ................###############................................. 1    2
// ..........###################................................... 2    4
// ..........################...................................... 3    8
// ............##########.......................................... 4   16
// ................................................................ 5   32
// ................................................................ 6   64
// ................................................................ 7  128

/*

After removing the entirely blank rows at the left...
The leftmost pixels set in the first eight rows of pixels (shown as page 1 above) are coded as
                                                     128, 192, 192, 192, 224, etc
In hexidecimal, you can see these in the data below
                                                    0x80,0xC0,0xC0,0xC0,0xE0,etc

The first column with data has a single pixel in the second row of page 3 corresponding to
  0x00 in Page 1
  0x00 in Page 2
  0x02 in Page 3
  0x00 in Page 4
*/

// Here's the data...
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xC0,0xC0,0xE0,0xE0,0xE0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0x70,0x70,0x60,0x60,0x40,0x00,0x00,
  0x00,0x00,0x00,0x80,0xC0,0x60,0x60,0x30,0x31,0x18,0x1C,0x9C,0x8E,0x8E,0x87,0xC7,0xC7,0xC3,0xC3,0xE3,0xE1,0xE1,0xE1,0xE1,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF8,0x38,
  0x02,0x05,0x05,0x04,0x06,0x06,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x83,0x83,0xC3,0xE3,0xF3,0xFB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0x3F,0x1F,0x0F,0x07,0x03,0x00,0x00,
  0x00,0x00,0x00,0x00,0x0C,0x0C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1E,0x1E,0x1F,0x1F,0x1F,0x0F,0x0F,0x0F,0x0F,0x07,0x07,0x07,0x03,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

// Here's the data for the second "SOLOMON SYSTECH" image, 69 pixels wide x 4 pages
const uint8_t solomon_systech_text_bitmap[] PROGMEM = {
  0x78,0xFC,0xFE,0xC6,0xC6,0x9E,0x9C,0x18,0x00,0xE0,0xFC,0xFC,0x0E,0x06,0x0E,0xFC,0xFC,0xF8,0x00,0x00,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0xE0,0xFC,0xFC,0x0E,0x06,0x06,0xFC,0xFC,0xF8,0x00,0x00,0xFE,0xFE,0x3C,0xFC,0xE0,0x00,0xF0,0xFC,0x3C,0xFE,0xFC,0x00,0x00,0xF8,0xFC,0xFE,0x06,0x06,0x1E,0xFC,0xFC,0x00,0x00,0xFE,0xFE,0xFC,0x7C,0xE0,0x00,0xFE,0xFE,
  0x1C,0x1C,0x3C,0x31,0x31,0x3F,0x1F,0x0F,0x00,0x03,0x1F,0x1F,0x38,0x30,0x38,0x3F,0x1F,0x0F,0x00,0x00,0x3F,0x3F,0x38,0x38,0x38,0x38,0x10,0x03,0x1F,0x1F,0x38,0x30,0x30,0x3F,0x1F,0x0F,0x00,0x00,0x3F,0x3F,0x00,0x01,0x1F,0x3F,0x1F,0x00,0x00,0x3F,0x3F,0x00,0x00,0x0F,0x1F,0x3F,0x30,0x30,0x3C,0x1F,0x1F,0x00,0x00,0x3F,0x3F,0x1F,0x00,0x07,0x1F,0x3F,0x3F,
  0x00,0x00,0x00,0x00,0xF0,0xF8,0xD8,0x88,0x18,0x38,0x38,0x20,0x00,0x38,0xF8,0xF8,0xC0,0xC0,0xF8,0x78,0x18,0x00,0xF0,0xF8,0xF8,0x88,0x18,0x38,0x38,0x20,0x00,0x18,0x18,0xF8,0xF8,0xF8,0x18,0x18,0x00,0x00,0xF8,0xF8,0xB8,0x18,0x18,0x18,0x18,0x00,0xE0,0xF8,0xF8,0x18,0x08,0x18,0x78,0x70,0x00,0x00,0xF8,0xF8,0xF8,0x80,0x80,0xF8,0xF8,0xF8,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x39,0x79,0x63,0x63,0x67,0x7F,0x3E,0x1C,0x00,0x00,0x00,0x2F,0x7F,0x7F,0x03,0x00,0x00,0x00,0x38,0x79,0x73,0x63,0x67,0x7F,0x3E,0x1C,0x00,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,0x00,0x00,0x7F,0x7F,0x73,0x63,0x63,0x63,0x61,0x00,0x1F,0x3F,0x7F,0x60,0x60,0x70,0x7C,0x3C,0x00,0x00,0x7F,0x7F,0x7F,0x03,0x03,0x7F,0x7F,0x7F,0x00,0x00,0x00
};

/*

Update - I found an online converter that produces the required format: http://www.majer.ch/lcd/adf_bitmap.php
That's much easier than rotating images and transforming text!
So ignore the below.

An online tool was used in the creation of these images.
https://marlinfw.org/tools/u8glib/converter.html  

By rotating the images, the right data bytes were produced but in the wrong layout:

  0x00,0x00,0x1C,0x78, // ...................###...####...
  0x00,0x00,0x1C,0xFC, // ...................###..######..
  0x00,0x00,0x3C,0xFE, // ..................####..#######.
  0x00,0x00,0x31,0xC6, // ..................##...###...##.
  0x39,0xF0,0x31,0xC6, // ..###..#####......##...###...##.
  0x79,0xF8,0x3F,0x9E, // .####..######.....#######..####.
  0x63,0xD8,0x1F,0x9C, // .##...####.##......######..###..
  0x63,0x88,0x0F,0x18, // .##...###...#.......####...##...
  0x67,0x18,0x00,0x00, // .##..###...##...................
etc.

The columns were then converted into rows.

Perhaps an efficient bitmap drawing routine could be written,
that used bitmap data in the same format as u8glib,
but for now, in order to have a really small library,
more work has to go in to preparing the data.

*/

#endif
